<?php


if (!defined('ABSPATH')) {
    exit;
}

function digits_socials_list()
{
    $home_url = rtrim(home_url(), '/');
    return array(
        'facebook' => array(
            'name' => 'Facebook',
            'loader' => 'FacebookAuth',
            'url' => "https://www.facebook.com/v16.0/dialog/oauth",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=facebook'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('App ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('App Secret ID')),
                array('checkbox' => true, 'name' => 'showContinueAs', 'value' => untdovr_gateway_field_label('Show Continue As')),
            ),
        ),
        'google' => array(
            'name' => 'Google',
            'loader' => 'GoogleAuth',
            'url' => "https://accounts.google.com/o/oauth2/v2/auth",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=google'),
            'inputs' => array(
                array('text' => true, 'name' => 'appName', 'value' => untdovr_gateway_field_label('Application Name')),
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
                array('checkbox' => true, 'name' => 'oneTapSignIn', 'value' => untdovr_gateway_field_label('One Tap Sign-in')),
            ),
        ),
        'apple' => array(
            'name' => 'Apple',
            'loader' => 'AppleAuth',
            'redirect_uri' => $home_url . '/social-login/redirect/apple',
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'teamId', 'value' => untdovr_gateway_field_label('Team ID')),
                array('text' => true, 'name' => 'keyFileId', 'value' => untdovr_gateway_field_label('Private Key ID')),
                array('textarea' => true, 'name' => 'privateKey', 'value' => untdovr_gateway_field_label('Private Key')),
            ),
        ),
        'twitter' => array(
            'name' => 'Twitter',
            'loader' => 'TwitterAuth',
            'url' => "https://api.twitter.com/oauth/authorize",
            'redirect_uri' => $home_url . '/social-login/redirect/twitter',
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'microsoft' => array(
            'name' => 'Microsoft',
            'loader' => 'MicrosoftAuth',
            'url' => "https://login.microsoftonline.com/{tenant}/oauth2/v2.0/authorize",
            'redirect_uri' => $home_url . '/social-login/redirect/microsoft',
            'inputs' => array(
                array('text' => true, 'name' => 'tenant', 'value' => untdovr_gateway_field_label('Tenant')),
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Application ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'wordpress' => array(
            'name' => 'WordPress',
            'loader' => 'WordpressAuth',
            'url' => "https://public-api.wordpress.com/oauth2/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=wordpress'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'github' => array(
            'name' => 'GitHub',
            'loader' => 'GithubAuth',
            'url' => "https://github.com/login/oauth/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=github'),
            'inputs' => array(
                array('text' => true, 'name' => 'appName', 'value' => untdovr_gateway_field_label('Application Name')),
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'gitlab' => array(
            'name' => 'GitLab',
            'loader' => 'GitlabAuth',
            'url' => "https://gitlab.com/oauth/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=gitlab'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'atlassian' => array(
            'name' => 'Atlassian',
            'loader' => 'AtlassianAuth',
            'url' => "https://auth.atlassian.com/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=atlassian'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Secret')),
            ),
        ),
        'bitbucket' => array(
            'name' => 'BitBucket',
            'loader' => 'BitbucketAuth',
            'url' => "https://bitbucket.org/site/oauth2/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=bitbucket'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Secret')),
            ),
        ),
        'discord' => array(
            'name' => 'Discord',
            'loader' => 'DiscordAuth',
            'url' => "https://discord.com/api/oauth2/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=discord'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Application ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'reddit' => array(
            'name' => 'Reddit',
            'loader' => 'RedditAuth',
            'url' => "https://www.reddit.com/api/v1/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=reddit'),
            'inputs' => array(
                array('text' => true, 'name' => 'redditUsername', 'value' => untdovr_gateway_field_label('Reddit Username')),
                array('text' => true, 'name' => 'appName', 'value' => untdovr_gateway_field_label('App Name')),
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'twitch' => array(
            'name' => 'Twitch',
            'loader' => 'TwitchAuth',
            'url' => "https://id.twitch.tv/oauth2/authorize",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=twitch'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'yahoo' => array(
            'name' => 'Yahoo',
            'loader' => 'YahooAuth',
            'url' => "https://api.login.yahoo.com/oauth2/request_auth",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=yahoo'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
        'linkedin' => array(
            'name' => 'Linkedin',
            'loader' => 'LinkedinAuth',
            'url' => "https://www.linkedin.com/oauth/v2/authorization",
            'redirect_uri' => admin_url('admin-ajax.php?action=digits_social_login&oauth=linkedin'),
            'inputs' => array(
                array('text' => true, 'name' => 'clientID', 'value' => untdovr_gateway_field_label('Client ID')),
                array('text' => true, 'name' => 'clientSecretID', 'value' => untdovr_gateway_field_label('Client Secret')),
            ),
        ),
    );
}

function digits_settings_social_login()
{
    $social_list = digits_socials_list();
    $saved_social_options = get_option('digits_option_social_settings');
    $enable_social_icon = false;

    if (!empty($saved_social_options)) {
        $enable_social_icon = $saved_social_options['enable_social_icon'];
    }

    ?>

    <table class='form-table digits_default_gateway_details_social_icons'>
        <tr class='enabledisable'>
            <th scope="row">
                <label class="top-10" for="digits_social_icon">
                    <?php _e('Show icons only', 'digsociallogin'); ?>
                </label>
            </th>
            <td>
                <?php digits_input_switch('enable_social_icon', $enable_social_icon); ?>
            </td>
        </tr>
    </table>

    <?php
    foreach ($social_list as $social_id => $social) {
        $social_name = esc_attr($social['name']);
        $social_fields = $social['inputs'];

        $social_options = [];

        $enable_status = false;
        if (!empty($saved_social_options[$social_id])) {
            $social_options = $saved_social_options[$social_id];
            $enable_status = $social_options['enable'];
        }

        ?>
        <div class="digits_gateway_container digits_gateway_api_box" id="digits_social_form" style="display: block;">
            <div class="dig_admin_sec_head dig_admin_sec_head_margin">
                        <span>
                            <?php echo $social_name; ?>
                        </span>
            </div>

            <table class='form-table digits_default_gateway_details <?php echo $social_name; ?>_social_gateway_table' style="display: table">
                <thead>
                <tr>
                    <th scope='row'><label class='top-10'>
                            <?php
                            echo sprintf(__('Enable %s', 'digsociallogin'), $social_name);
                            ?>
                        </label>
                    </th>
                    <td data-show="<?php echo $social_name . '_fields_row '; ?>"
                        class="digits_social_gateway_toggle">
                        <?php digits_input_switch('enable_' . $social['name'] . '_auth', $enable_status); ?>
                    </td>
                </tr>
                </thead>
                <tbody id='digits_social_form_<?php echo $social_name; ?>'>
                <?php

                foreach ($social_fields as $fields) {
                    $field_name = esc_attr($social_name . "_" . $fields['name']);
                    $field_value = '';
                    if (!empty($social_options[$fields['name']])) {
                        $field_value = $social_options[$fields['name']];
                    }
                    ?>
                    <tr class='<?php echo $social_name . '_fields_row '; ?> gateway_conf'
                        style="display:none;"
                        id='<?php echo $field_name; ?>_social_form_fields'>
                        <th scope='row'>
                            <label for='<?php echo $field_name; ?>'>
                                <?php _e($fields['value'], 'digsociallogin'); ?>
                            </label>
                        </th>
                        <td>
                            <?php
                            if (isset($fields['checkbox'])) {

                                digits_input_switch($field_name, $field_value);

                            } else if (isset($fields['textarea'])) {
                                ?>
                                <textarea
                                        class='regular-text dig_sens_data'
                                        name='<?php echo $field_name; ?>'
                                        id='<?php echo $field_name; ?>'
                                        placeholder='<?php esc_attr_e($fields['value'], 'digsociallogin'); ?>'
                                        autocomplete='off'><?php echo esc_attr($field_value); ?></textarea>
                                <?php
                            } else {
                                ?>
                                <input type='text' class='regular-text dig_sens_data'
                                       name='<?php echo $field_name; ?>'
                                       id='<?php echo $field_name; ?>'
                                       value='<?php echo esc_attr($field_value); ?>'
                                       placeholder='<?php esc_attr_e($fields['value'], 'digsociallogin'); ?>'
                                       autocomplete='off'>
                                <?php
                            }
                            ?>
                        </td>
                    </tr>

                    <?php
                }

                if (!empty($social['redirect_uri'])) {
                    ?>
                    <tr class="<?php echo $social_name . '_fields_row '; ?>" style="display:none;">
                        <th scope='row'>
                            <label for='<?php echo $social_name; ?>_redirect_uri'>
                                <?php esc_attr_e('Redirect URI', 'digsociallogin'); ?>
                            </label>
                        </th>
                        <td>
                            <div class="digits_shortcode_tbs">
                                <input type="text"
                                       style="padding-right: 40px"
                                       value="<?php echo esc_attr($social['redirect_uri']); ?>"
                                       readonly="">
                                <img class="dig_copy_shortcode" alt="Copy"
                                     src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='%2326263A' stroke-width='2' stroke-linecap='round' stroke-linejoin='round' class='feather feather-copy'%3E%3Crect x='9' y='9' width='13' height='13' rx='2' ry='2'%3E%3C/rect%3E%3Cpath d='M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1'%3E%3C/path%3E%3C/svg%3E">
                            </div>

                        </td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
            <script>
                jQuery(function () {
                    jQuery('.digits_social_gateway_toggle input').on('change update', function (e) {

                        var table = jQuery(this).closest('table');
                        var fields = table.find('.' + jQuery(this).closest('td').data('show'));

                        if (jQuery(this).is(':checked')) {
                            fields.show();
                        } else {
                            fields.hide();
                        }
                        return true;
                    }).trigger('update');
                })
            </script>
        </div>
        <?php
    }
}


add_action('digits_save_settings_data', 'update_digits_social_settings');
function update_digits_social_settings()
{
    $social_list = digits_socials_list();
    $social_values = array();
    $social_values['enable_social_icon'] = (bool)$_REQUEST['enable_social_icon'];
    foreach ($social_list as $key => $social) {
        $social_values[$key] = array();
        if (isset($_REQUEST['enable_' . $social['name'] . '_auth'])) {
            $social_values[$key]['enable'] = (bool)$_REQUEST['enable_' . $social['name'] . '_auth'];

            $social_name = $social['name'];
            $social_fields = $social['inputs'];

            foreach ($social_fields as $fields) {

                if (isset($_REQUEST[$social_name . "_" . $fields['name']])) {
                    $social_values[$key][$fields['name']] = $_REQUEST[$social_name . "_" . $fields['name']];
                }
            }
        }
    }
    update_option('digits_option_social_settings', $social_values);
}
