<?php

namespace Digits\SocialLogin\Auths;

use DigitsFormHandler\UserRedirection;

abstract class SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;

    public function __construct()
    {

        add_action('login_enqueue_scripts', [$this, 'enqueue_scripts']);
        add_action('login_footer', [$this, 'enqueue_scripts']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
        add_action('login_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('wp_footer', [$this, 'process_token']);
        add_action('login_footer', [$this, 'process_token']);
    }

    public function default_layout($id, $name)
    {
        ?>
        <div class="digits-social-btn digits_connect_social_login"
             id="<?php echo esc_attr($id); ?>"
             data-id="<?php echo $this->client_id; ?>">
            <div class="digits-social-icon-wrapper">
                <div class="digits-social-icon">
                </div>
            </div>
            <div class="digits-social-text">
                <?php
                $label = __('Use %s', 'digsociallogin');
                echo sprintf($label, $name);
                ?>
            </div>
            <input type="hidden" class="social_name" value="<?php echo esc_attr(strtolower($name)); ?>">
            <input type="hidden" class="login_uri" value="<?php echo $this->get_url(); ?>">
        </div>
        <?php
    }

    public function get_url()
    {
        return '';
    }

    abstract public function process_oauth_token();

    abstract public function render();

    abstract public function enqueue_scripts();

    abstract public function process_token();

    public function redirect(array $response)
    {
        wp_safe_redirect(home_url());
        die();
    }

    public function success_view(array $response)
    {

        $redirect_url = UserRedirection::get_redirect_uri('login', false, '');

        ?>
        <h4><?php esc_attr_e('Please wait', 'digsociallogin'); ?></h4>
        <script>
            window.opener.postMessage({
                key: 'digits_social_auth_success',
                redirect: '<?php echo esc_attr($redirect_url);?>'
            }, '<?php echo home_url();?>');
            window.close();
        </script>
        <?php
        die();
    }

    public function error_view(\Exception $e)
    {
        $this->close_window();
    }

    public function nonce_fail()
    {
        $this->close_window();
    }

    public function invalid_info()
    {
        $this->close_window();
    }

    public function close_window()
    {
        ?>
        <h4><?php esc_attr_e('Oops, Something went wrong!', 'digsociallogin'); ?></h4>
        <script>
            window.close();
        </script>
        <?php
        die();
    }
}
