<?php

namespace Digits\SocialLogin\Auths;

use DigitsSocialOAuth2;

class AppleAuth extends SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;
    private $settings;

    function __construct($settings, $social_info, $icon_only)
    {
        $this->settings = $settings;
        $this->client_id = esc_attr($settings['clientID']);
        $this->redirect_url = $social_info['redirect_uri'];
        $this->icon_only = $icon_only;


        parent::__construct();

    }

    public function render()
    {
        $this->default_layout('digits_apple_login', 'Apple');

    }

    public function get_url()
    {
        $query = [
            'client_id' => urlencode($this->client_id),
            'scope' => urlencode('name email'),
            'response_type' => 'code',
            'redirect_uri' => urlencode($this->redirect_url),
            'state' => wp_create_nonce('apple_login'),
            'response_mode' => 'form_post',
        ];
        $base_url = 'https://appleid.apple.com/auth/authorize';
        return add_query_arg($query, $base_url);
    }


    public function enqueue_scripts()
    {
    }

    public function process_token()
    {

    }

    public function nonce_fail()
    {
        wp_die(__('Security verification failed, Please try again!', 'digsociallogin'));
    }

    public function invalid_info()
    {
        wp_die(__('Error, Please try again!', 'digsociallogin'));
    }

    public function process_oauth_token()
    {
        if (empty($_REQUEST['code'])) {
            $this->invalid_info();
            die();
        }
        if (!wp_verify_nonce($_REQUEST['state'], 'apple_login')) {
            $this->nonce_fail();
            die();
        }
        try {

            $code = $_REQUEST['code'];
            $provider = new \League\OAuth2\Client\Provider\Apple([
                'clientId' => $this->client_id,
                'teamId' => $this->settings['teamId'],
                'keyFileId' => $this->settings['keyFileId'],
                'keyFilePath' => $this->settings['privateKey'],
                'redirectUri' => $this->redirect_url,
            ]);

            $token = $provider->getAccessToken('authorization_code', [
                'code' => $code
            ]);

            $user = $provider->getResourceOwner($token);

            $first_name = $user->getFirstName();
            $last_name = $user->getLastName();

            $id = $user->getId();
            $name = $first_name . ' ' . $last_name;
            $username = '';
            $email = $user->getEmail();

            $response = digits_social_create_user($name, $email, 'apple', $username, $id);

            $this->success_view($response);
        } catch (\Exception $e) {
            $this->error_view($e);
        }
    }

    public function success_view($response)
    {
        wp_redirect(home_url());
        die();
    }

    public function error_view($e)
    {
        wp_die("Error");
    }
}
