<?php

/*
 * Plugin Name: افزودنی دیجیتس | ورود با شبکه های اجتماعی
 * Description: قابلیت ورود به سیستم با شبکه اجتماعی را با همه ارائه دهندگان اصلی در کنار دیجیتس ارائه دهید.
 * Version: 1.7
 * Plugin URI: https://www.rtl-theme.com/digits-wordpress-plugin/
 * Author URI: https://www.rtl-theme.com/digits-wordpress-plugin/
 * Author: گروه اتوماتیک سایت راستچین
 * Text Domain: digsociallogin
 * Requires PHP: 7.2
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}


require dirname(__FILE__) . '/handler.php';
require dirname(__FILE__) . '/Puc/v4p6/Factory.php';
require dirname(__FILE__) . '/Puc/v4/Factory.php';
require dirname(__FILE__) . '/Puc/v4p6/Autoloader.php';
new Puc_v4p6_Autoloader();

foreach (
    array(
        'Plugin_UpdateChecker' => 'Puc_v4p6_Plugin_UpdateChecker',
        'Vcs_PluginUpdateChecker' => 'Puc_v4p6_Vcs_PluginUpdateChecker',
    )
    as $pucGeneralClass => $pucVersionedClass
) {
    Puc_v4_Factory::addVersion($pucGeneralClass, $pucVersionedClass, '4.6');

    Puc_v4p6_Factory::addVersion($pucGeneralClass, $pucVersionedClass, '4.6');
}


function digits_addon_digsociallogin()
{
    return 'digsociallogin';
}


function dig_show_sociallogin($active_tab)
{
    ?>
    <div data-tab="digsociallogintab"
         class="dig_admin_in_pt digsociallogintab digtabview <?php echo $active_tab == digits_addon_digsociallogin() ? 'digcurrentactive' : '" style="display:none;'; ?>">
        <?php digad_show_socialogin_settings(); ?>
    </div>

    <?php

}

add_action('digits_settings_page', 'dig_show_sociallogin');


function digsociallogin_addon($list)
{
    $list[] = 'digsociallogin';
    return $list;
}

add_filter('digits_addon', 'digsociallogin_addon');

function digsociallogin_addon_tab($tabs)
{
    $tabs['digsociallogin'] = array('label' => esc_attr__('Social Logins', 'digsociallogin'));
    return $tabs;
}

add_filter('digits_admin_addon_tab', 'digsociallogin_addon_tab');
function digsociallogin_load_plugin_textdomain()
{
    load_plugin_textdomain('digsociallogin', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}

add_action('plugins_loaded', 'digsociallogin_load_plugin_textdomain');
?>
